% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roary_2_pagoo.R
\name{roary_2_pagoo}
\alias{roary_2_pagoo}
\title{Read roary's output into a pagoo's R6 class object}
\usage{
roary_2_pagoo(gene_presence_absence_csv, gffs, sep = "__")
}
\arguments{
\item{gene_presence_absence_csv}{\code{character}, path to the
"gene_presence_absence.csv" file. (Do not confuse with the file with the
same name but with \code{.Rtab} extension).}

\item{gffs}{A \code{character} vector with paths to original gff files used
as roary's input. Typically the return value of \code{list.files()} function.
This parameter is optional but highly recommended if you want to manipulate
sequences.}

\item{sep}{\code{character}. Default: \code{"__"} (two underscores). See
\link[pagoo]{PgR6MS} for a more detail argument description.}
}
\value{
A pagoo's R6 class object. Either \link[pagoo]{PgR6M}, if \code{gffs}
argument is left empty, or \link[pagoo]{PgR6MS} if path to gff files is
provided.
}
\description{
This function handle conversion of \href{https://sanger-pathogens.github.io/Roary/}{roary}'s output files into
a pagoo R6 class object. It takes the "gene_presence_absence.csv" file and
(optionally but recommended) gff input file paths, and returns an object of
class \code{\link[pagoo]{PgR6MS}} (or \code{\link[pagoo]{PgR6M}} if left
empty the \code{gffs} argument).
}
\examples{
\dontrun{
gffs <- list.files(path = "path/to/gffs/",
                   pattern = "[.]gff$",
                   full.names = TRUE)
gpa_csv <- "path/to/gene_presence_absence.csv"

library(pagoo)
pg <- roary_2_pagoo(gene_presence_absence_csv = gpa_csv,
                    gffs = gffs)
}
}
\references{
Andrew J. Page, Carla A. Cummins, Martin Hunt, Vanessa K. Wong, Sandra Reuter,
 Matthew T. G. Holden, Maria Fookes, Daniel Falush, Jacqueline A. Keane, Julian
 Parkhill, "Roary: Rapid large-scale prokaryote pan genome analysis",
 Bioinformatics, 2015;31(22):3691-3693
}
