% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rates.R
\name{LRI}
\alias{LRI}
\title{Log-rate, Log-interval (LRI) method of Gingerich}
\usage{
LRI(y, gen.per.t = 1e+06, draw = TRUE)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{gen.per.t}{the number of generations per unit time}

\item{draw}{logical, if TRUE, a plot is produced}
}
\value{
A named vector with three elements: \code{Intercept}, \code{slope}, and
 \code{GenerationalRate}
}
\description{
Gingerich (1993) introduced a method that plots on log-log scale,
 the rate and interval for each pair of samples in an evolutionary sequence.
 On this plot, the slope is interpreted as an indicator of evolutionary mode
 (-1 for stasis, 0.5 for random walk, 0 for directional), and the intercept
 is interpreted as a measure of the rate of evolution over one generation.
}
\details{
Following Gingerich (1993), a robust line is fit through the
 points by minimizing the sum of absolute deviations. If generations are one
 year long and time is measured in Myr, \code{gen.per.t}= 1e6.
}
\note{
This method was important in early attempts to disentangle
 evolutionary tempo and mode. Likelihood-based methods have a more sound
 statistical basis, and in particular the estimation of 'Generational Rates' using
 LRI is compromised by sampling error; see Hunt (2012) and the example below.
}
\examples{
set.seed(1)
xFast <- sim.GRW(ns = 20, ms = 0.5, vs = 0.2)  # fast evolution
xSlow <- sim.Stasis(ns = 20, omega = 0)        # strict stasis (zero rates)
lri.Fast <- LRI(xFast, draw = FALSE)
lri.Slow <- LRI(xSlow, draw = FALSE)
print(lri.Fast[3], 4)
print(lri.Slow[3], 4)  # LRI thinks strict stasis rates are MUCH faster!
}
\references{
Gingerich, P.D. 1993. Quantification and comparison of
 evolutionary rates. \emph{American Journal of Science} 293-A:453–478. \cr \cr
 Hunt, G. 2012. Measuring rates of phenotypic evolution and the
 inseparability of tempo and mode. \emph{Paleobiology} 38:351–373.
}
\seealso{
\code{\link{lynchD}}
}
