% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm.R
\name{checkSSMresiduals}
\alias{checkSSMresiduals}
\title{Compute and (optionally) plot residuals from SSM model fit}
\usage{
checkSSMresiduals(
  y,
  w,
  show.plot = TRUE,
  resid.type = c("standardized", "unstandardized")
)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{w}{a \code{paleoTSfit} object, where the fitting functions uses SSM}

\item{show.plot}{logical, if \code{TRUE}, several diagnostic plots are shown}

\item{resid.type}{residual type, either "standardized" or "unstandardized"}
}
\value{
a vector of residuals, returned invisibly
}
\description{
Compute and (optionally) plot residuals from SSM model fit
}
\details{
It is recommended that \code{resid.type} be set to the default, "standardized", which will scale residuals by their expected standard deviation
}
\examples{
y <- sim.GRW(ns = 50, ms = 0.2)
w <- fitSimple(y, model = "URW", method = "SSM")  # wrong model
checkSSMresiduals(y, w, show.plot = TRUE) # positive residuals show model mis-fit
}
