% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirror.R
\name{mirrorfill1}
\alias{mirrorfill1}
\title{Fill missing landmarks for a single specimen using mirrored values from other side of object}
\usage{
mirrorfill1(s, l1, l2)
}
\arguments{
\item{s}{An n x 3 matrix containing 3D landmark data of n landmarks.}

\item{l1}{Vector of indices for which landmarks to use to make a specimen midline.}

\item{l2}{Vector or matrix of pairs of symmetrical landmarks.}
}
\description{
Given an n x 3 matrix, replace a set of landmarks using their mirrored counterpart.
}
\details{
\code{l2} should be either 
 \itemize{
   \item An even length vector containing pairs of landmarks on either side of the specimen. 
     i.e. l2[1] and l2[2] are paired, l2[3] and l2[4] are paired etc.
   \item A two column matrix with each row giving a pair of symmetrical landmarks.
 }
}
\examples{
 # Make data that is reflected in x plane
 s <- matrix(rep(1:21, 2), byrow = TRUE, ncol = 3)
 s[1:7, 1] <- -s[1:7, 1]

 # Now remove some data
 s[1, ] <- NA
 
 # Mirror point 1 using it's complimentary landmark, point 8.
 mirrorS <- mirrorfill1(s, l1 = c(2:7, 9:14), l2 = c(1, 8))
}

