% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_subset.R
\name{region_subset}
\alias{region_subset}
\title{Function generates a region subset of matrix values based on a subset of coordinates within the original region (using nearest spatial neighbour if coordinates differ).}
\usage{
region_subset(orig_coords = NULL, orig_matrix = NULL, subset_coords = NULL)
}
\arguments{
\item{orig_coords}{Data frame (or matrix) of original/full region of X-Y coordinates (WGS84) in longitude (degrees West) and latitude (degrees North).}

\item{orig_matrix}{Matrix of original values with rows corresponding to the original/full region coordinates.}

\item{subset_coords}{Data frame (or matrix) of X-Y subset region coordinates (WGS84) in longitude (degrees West) and latitude (degrees North).}
}
\value{
A matrix of values corresponding to the subset region coordinates (using nearest spatial neighbor if original and subset coordinates differ).
}
\description{
\code{region_subset} generates a region subset of matrix values based on a subset of coordinates within the original region (using nearest spatial neighbour if coordinates differ).
}
\examples{
coordinates <- data.frame(x = rep(seq(-178.02, -178.06, -0.01), 5),
                          y = rep(seq(19.02, 19.06, 0.01), each = 5))
values <- matrix(seq(1, 25, 1))
subset <- data.frame(x = rep(seq(-178, -178.04, -0.005), 7), 
                     y = rep(seq(19.03, 19.06, 0.005), each = 9))
region_subset(coordinates, values, subset) # nearest neighbor interpolation

}
