% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixRootTime.R
\name{fixRootTime}
\alias{fixRootTime}
\title{Modify, Drop or Bind Terminal Branches of Various Types (Mainly for Paleontological Phylogenies)}
\usage{
fixRootTime(treeOrig, treeNew, testConsistentDepth = TRUE,
  fixingMethod = "matchCladeTransferNodeAge")
}
\arguments{
\item{treeOrig}{A \code{phylo} object of a time-scaled
phylogeny with a \code{$root.time} element.}

\item{treeNew}{A \code{phylo} object containing a
modified form of \code{treeOrig} (with
no extra tip taxa added, but possibly with
some tip taxa removed).}

\item{testConsistentDepth}{A logical, either \code{TRUE}
or \code{FALSE}. If \code{TRUE} (the default)
the tree's root-to-furthest-tip depth is tested
to make sure this depth is
not greater than the new \code{$root.time}
appended to the output tree.}

\item{fixingMethod}{must be an character value, with a length of 1.

The default option \code{fixingMethod = "matchCladeTransferNodeAge"}, 
will determine the \code{$root.time} of the new tree by
comparing the clades of taxa between the two input
trees. The new root age assigned is the age of
(\emph{1}) the \code{treeOrig} clade that contains \emph{all}
taxa present in \code{treeNew} and, if the set of (1)
contains multiple clades, (\emph{2}) the clade in the
first set that contains the fewest taxa not in
\code{treeNew}. 

If \code{fixingMethod = "rescaleUsingTipToRootDist"}, 
the \code{root.time} assigned to \code{treeNew} is the
\code{$root.time} of \code{treeOrig}, adjusted
based on the change in total tree depth between \code{treeOrig} and
\code{treeNew}, as measured between the root and
the first matching taxon in both trees. The
\code{"rescaleUsingTipToRootDist"} option was the default for 
\code{fixRootTime} prior to paleotree v2.3, and is the
option used by function \code{\link{minBranchLength}} when
applied to a tree with pre-existing root age element.}
}
\value{
Gives back a modified phylogeny as a \code{phylo} object, with a
modified \code{$root.time} element.
}
\description{
Modifying a dated tree with \code{$root.time} elements often
changes the actual timing of the root relative to the 
tips, such as when dropping tips, extending branches, or
shift node ages backwards. When such modifications occur, 
the function \code{fixRootTime} can be used to find
the correct root age. 
This function is mainly used as a
utility function called by other tree-modifying functions discussed
in the manual page for \code{\link{modifyTerminalBranches}}.
This is typically perfomed via the function \code{\link{fixRootTime}}.
}
\examples{

\donttest{

#testing dropPaleoTip... and fixRootTime by extension

#simple example
tree <- read.tree(text = "(A:3,(B:2,(C:5,D:3):2):3);")
tree$root.time <- 10
plot(tree,no.margin = FALSE)
axisPhylo()

# now a series of tests, dropping various tips
(test <- dropPaleoTip(tree,"A")$root.time) #  = 7
(test[2] <- dropPaleoTip(tree,"B")$root.time) #  = 10
(test[3] <- dropPaleoTip(tree,"C")$root.time) #  = 10
(test[4] <- dropPaleoTip(tree,"D")$root.time) #  = 10
(test[5] <- dropPaleoTip(tree,c("A","B"))$root.time) #  = 5
(test[6] <- dropPaleoTip(tree,c("B","C"))$root.time) #  = 10
(test[7] <- dropPaleoTip(tree,c("A","C"))$root.time) #  = 7
(test[8] <- dropPaleoTip(tree,c("A","D"))$root.time) #  = 7

# is it all good? if not, fail so paleotree fails...
if(!identical(test,c(7,10,10,10,5,10,7,7))){stop("fixRootTime fails!")}

}
}
\seealso{
\code{\link{modifyTerminalBranches}},
\code{\link{minBranchLength}}
}
\author{
David W. Bapst
}
