% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palr.R
\name{chl_pal}
\alias{chl_pal}
\alias{chlPal}
\title{Ocean colour colours for chlorophyll-a.}
\usage{
chl_pal(x, palette = FALSE, alpha = 1)

chlPal(x, palette = FALSE, alpha = 1, ...)
}
\arguments{
\item{x}{a vector of data values or a single number}

\item{palette}{logical, if \code{TRUE} return a list with matching colours and values}

\item{alpha}{value in 0,1 to specify opacity}

\item{...}{currently unused}
}
\value{
colours, palette, or function, see Details
}
\description{
Ocean colour palette for chlorophyll-a.
}
\details{
Flexible control of the chlorophyll-a palette. If \code{x} is a
single number, the function returns that many colours evenly
spaced from the palette. If \code{x} is a vector of multiple
values the palette is queried for colours matching those values,
and these are returned. If \code{x} is missing and \code{palette}
is \code{FALSE} then a function is returned that will generate n
evenly spaced colours from the palette, as per
\code{\link{colorRampPalette}}.
}
\examples{
\dontrun{
chl <- raadtools::readchla(xylim = c(100, 110, -50, -40))
## just get a small number of evenly space colours
plot(chl, col = chl_pal(10))
## store the full palette and work with values and colours
pal <- chl_pal()
## the standard full palette
plot(chl, breaks = pal$breaks, col = pal$cols)
## a custom set of values with matching colours
plot(chl, col = chl_pal(pal$breaks[seq(1, length(pal$breaks), length = 10)]))
## any number of colours stored as a function
myfun <- chl_pal()
plot(chl, col = myfun(18))
## just n colours
plot(chl, col = chl_pal(18))
}
}
\references{
Derived from a file once found at 'http://oceancolor.gsfc.nasa.gov/DOCS/palette_chl_etc.txt'
}
