% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulative-coefficient.R
\name{get_cumu_coef}
\alias{get_cumu_coef}
\alias{get_cumu_coef.gam}
\alias{get_cumu_coef.aalen}
\alias{get_cumu_coef.cox.aalen}
\title{Extract cumulative coefficients (cumulative hazard differences)}
\usage{
get_cumu_coef(model, data = NULL, terms, ...)

\method{get_cumu_coef}{gam}(model, data, terms, ...)

\method{get_cumu_coef}{aalen}(model, data = NULL, terms, ci = TRUE,
  ...)

\method{get_cumu_coef}{cox.aalen}(model, data = NULL, terms, ci = TRUE,
  ...)
}
\arguments{
\item{model}{Object from which to extract cumulative coefficients.}

\item{data}{Additional data if necessary.}

\item{terms}{A character vector of variables for which the cumulative
coefficient should be calculated.}

\item{...}{Further arguments passed to methods.}

\item{ci}{Logical. Indicates if confidence intervals should be returned as
well.}
}
\description{
These functions are designed to extract (or mimic) the cumulative coefficients
usually used in additive hazards models (Aalen model) to depict (time-varying)
covariate effects. For PAMMs, these are the differences
between the cumulative hazard rates where all covariates except one have the
identical values. For a numeric covariate of interest, this calculates
\eqn{\Lambda(t|x+1) - \Lambda(t|x)}.  For non-numeric covariates
the cumulative hazard of the reference level is subtracted from
the cumulative hazards evaluated at all non reference levels. Standard
errors are calculated using the delta method.
}
