% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval-information.R
\name{ped_info}
\alias{ped_info}
\title{Extract interval information and median/modus values for covariates}
\usage{
ped_info(ped)
}
\arguments{
\item{ped}{An object of class \code{ped} as returned by
\code{\link[pammtools]{as_ped}}.}
}
\value{
A data frame with one row for each unique interval in \code{ped}.
}
\description{
Given an object of class \code{ped}, returns data frame with one row for each
interval containing interval information, mean values for numerical
variables and modus for non-numeric variables in the data set.
}
\examples{
ped <- tumor[1:4,] \%>\% as_ped(Surv(days, status)~ sex + age)
ped_info(ped)
}
\seealso{
\code{\link[pammtools]{int_info}}, \code{\link[pammtools]{sample_info}}
}
