% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params}
\alias{params}
\alias{toParamVec}
\alias{toMatrixPparams}
\title{Manipulating \code{panelPomp} object parameter formats}
\usage{
toParamVec(pParams)

toMatrixPparams(listPparams)
}
\arguments{
\item{pParams}{A list with both shared (vector) and unit-specific (matrix) parameters.}

\item{listPparams}{PanelPomp parameters in list format}
}
\value{
\code{toParamVec()} returns model parameters in vector form. This function
is the inverse of \link{toParamList}

\code{toMatrixPparams()} returns an object of class \code{matrix} with the
model parameters in matrix form.
}
\description{
These facilitate keeping a record of evaluated log likelihoods.
}
\examples{
prw <- panelRandomWalk()
toParamVec(coef(prw, format = 'list'))
toMatrixPparams(coef(prw, format = 'list'))
}
\author{
Carles \Breto
}
