% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asym_gee.R, R/wb_gee.R
\name{tidy.asym_gee}
\alias{tidy.asym_gee}
\alias{tidy.wbgee}
\alias{glance.wbgee}
\title{Tidy methods for \code{wbgee} models}
\usage{
\method{tidy}{asym_gee}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{tidy}{wbgee}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{glance}{wbgee}(x, ...)
}
\arguments{
\item{x}{A \code{wbgee} object.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval if
\code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1. Defaults
to 0.95, which corresponds to a 95 percent confidence interval.}

\item{...}{Ignored}
}
\description{
\code{panelr} provides methods to access \code{wbgee} data in a tidy format
}
\examples{
data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
model <- wbgee(lwage ~ lag(union) + wks, data = wages)
if (requireNamespace("broom")) {
  broom::tidy(model)
}
}
