% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamUty.R
\name{ParamUty}
\alias{ParamUty}
\title{Untyped Parameter}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Param}.
}
\description{
A \link{Param} to describe untyped parameters.
}
\section{Construction}{
\preformatted{ParamUty$new(id, default = NO_DEF, tags = character(), custom_check = NULL)
}

Arguments of \link{Param}, and additionally:
\itemize{
\item \code{custom_check} :: \verb{function()}\cr
Custom function to check the feasibility.
Function which checks the input.
Must return 'TRUE' if the input is valid and a string with the error message otherwise.
Defaults to \code{NULL}, which means that no check is performed.
}
}

\section{Fields}{

Fields of \link{Param}, and additionally:
\itemize{
\item \code{lower} :: \code{numeric(1)}\cr
Lower bound.
Always \code{NA} for this parameter.
\item \code{upper} :: \code{numeric(1)}\cr
Upper bound.
Always \code{NA} for this parameter.
\item \code{levels} :: \code{NULL}\cr
Allowed levels.
Always \code{NULL} for this parameter.
\item \code{nlevels} :: \code{numeric(1)} \cr
Number of categorical levels.
Always \code{Inf} for this parameter.
\item \code{is_bounded} :: \code{FALSE}\cr
Are the bounds finite?
Always \code{FALSE} for this parameter.
}
}

\section{Methods}{

See \link{Param}.
}

\examples{
ParamUty$new("untyped", default = Inf)
}
\seealso{
Other Params: 
\code{\link{ParamDbl}},
\code{\link{ParamFct}},
\code{\link{ParamInt}},
\code{\link{ParamLgl}},
\code{\link{Param}}
}
\concept{Params}
