% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterSet.R
\name{pset}
\alias{pset}
\title{Convenience Function for Constructing a ParameterSet}
\usage{
pset(prms, tag_properties = NULL)
}
\arguments{
\item{prms}{(\code{list()}) \cr List of \link{prm} objects.}

\item{tag_properties}{(\code{list()}) \cr
List of tag properties. Currently support properties are: i) 'required' -
parameters with this tag property must be non-NULL; ii) 'linked' - only one
parameter in a linked tag group can be non-NULL and the others should be
NULL, this only makes sense with an associated \code{trafo}; iii) 'unique' -
parameters with this tag must have no duplicated elements, only makes sense
for vector parameters.}
}
\description{
See \link{ParameterSet} for full details.
}
\examples{
library(set6)

prms <- list(
 prm("a", Set$new(1), 1, tags = "t1"),
 prm("b", "reals", 1.5, tags = "t1"),
 prm("d", "reals", 2, tags = "t2")
)
p <- pset(prms)
}
