% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equivalence_test.R
\name{equivalence_test.lm}
\alias{equivalence_test.lm}
\title{Equivalence test}
\usage{
\method{equivalence_test}{lm}(x, range = "default", ci = 0.95,
  verbose = TRUE, ...)
}
\arguments{
\item{x}{A statistical model.}

\item{range}{The range of practical equivalence of an effect. May be \code{"default"},
to automatically define this range based on properties of the model's data.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{verbose}{Toggle off warnings.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame.
}
\description{
Compute the equivalence test for frequentist models.
}
\examples{
m <- lm(mpg ~ gear + wt + cyl + hp, data = mtcars)
equivalence_test(m)
}
\seealso{
For more details, see \code{\link[bayestestR:equivalence_test]{equivalence_test}}.
}
