% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_value.R, R/robust_estimation.R
\name{p_value}
\alias{p_value}
\alias{p_value.lmerMod}
\alias{p_value.glmmTMB}
\alias{p_value.MixMod}
\alias{p_value_robust}
\title{p-values}
\usage{
p_value(model, ...)

\method{p_value}{lmerMod}(model, method = "wald", ...)

\method{p_value}{glmmTMB}(model, component = c("all", "conditional",
  "zi", "zero_inflated"), ...)

\method{p_value}{MixMod}(model, component = c("all", "conditional", "zi",
  "zero_inflated"), ...)

p_value_robust(model, vcov_estimation = "HC", vcov_type = c("HC3",
  "const", "HC", "HC0", "HC1", "HC2", "HC4", "HC4m", "HC5"),
  vcov_args = NULL, ...)
}
\arguments{
\item{model}{A statistical model.}

\item{...}{Arguments passed down to \code{standard_error_robust()} when confidence intervals or p-values based on robust standard errors should be computed.}

\item{method}{For mixed models, can be \link[=p_value_wald]{"wald"} (default) or \link[=p_value_kenward]{"kenward"}.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}

\item{vcov_estimation}{String, indicating the suffix of the \code{vcov*()}-function
from the \pkg{sandwich}-package, e.g. \code{vcov_estimation = "CL"} (which
calls \code{\link[sandwich]{vcovCL}} to compute clustered covariance matrix
estimators), or \code{vcov_estimation = "HC"} (which calls
\code{\link[sandwich]{vcovHC}} to compute heteroskedasticity-consistent
covariance matrix estimators).}

\item{vcov_type}{Character vector, specifying the estimation type for the
robust covariance matrix estimation (see \code{\link[sandwich]{vcovHC}} for
details).}

\item{vcov_args}{List of named vectors, used as additional arguments that
are passed down to the \pkg{sandwich}-function specified in \code{vcov_estimation}.}
}
\value{
The p-values.
}
\description{
This function attempts to return, or compute, p-values of a model's parameters. The nature of the p-values is different depending on the model:
\itemize{
\item Mixed models (lme4): By default, p-values are based on Wald-test approximations (see \code{\link{p_value_wald}}). For \code{lmerMod} objects, if \code{method = "kenward"}, p-values are based on Kenward-Roger approximations, i.e. \code{\link{p_value_kenward}} is called.
}
}
\examples{
model <- lme4::lmer(Petal.Length ~ Sepal.Length + (1 | Species), data = iris)
p_value(model)
}
