% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dof_satterthwaite.R, R/p_value_satterthwaite.R,
%   R/se_satterthwaite.R
\name{dof_satterthwaite}
\alias{dof_satterthwaite}
\alias{p_value_satterthwaite}
\alias{se_satterthwaite}
\title{p-values using Satterthwaite approximation}
\usage{
dof_satterthwaite(model)

p_value_satterthwaite(model, dof = NULL)

se_satterthwaite(model)
}
\arguments{
\item{model}{A statistical model.}

\item{dof}{Degrees of Freedom.}
}
\value{
The p-values.
}
\description{
An approximate F-test based on the Satterthwaite (1946) approach.
}
\details{
Inferential statistics (like p-values, confidence intervals and
standard errors) may be biased in mixed models when the number of clusters
is small (even if the sample size of level-1 units is high). In such cases
it is recommended to approximate a more accurate number of degrees of freedom
for such inferential statitics. Unlike simpler approximation heuristics
like the "m-l-1" rule (\code{dof_ml1}), the Satterthwaite approximation is
also applicable in more complex multilevel designs. However, the "m-l-1"
heuristic also applies to generalized mixed models, while approaches like
Kenward-Roger or Satterthwaite are limited to linear mixed models only.
}
\examples{
\donttest{
library(lme4)
model <- lmer(Petal.Length ~ Sepal.Length + (1 | Species), data = iris)
p_value_satterthwaite(model)
}

}
\references{
Satterthwaite FE (1946) An approximate distribution of estimates of variance components. Biometrics Bulletin 2 (6):110–4.
}
\seealso{
\code{dof_satterthwaite()} and \code{se_satterthwaite()} are small helper-functions
to calculate approximated degrees of freedom and standard errors for model
parameters, based on the Satterthwaite (1946) approach.
\cr \cr
\code{\link{dof_kenward}} and \code{\link{dof_ml1}} approximate degrees
of freedom bases on Kenward-Roger's method or the "m-l-1" rule.
}
