% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBDestimate.R
\name{IBDestimate}
\alias{IBDestimate}
\title{Relatedness estimation}
\usage{
IBDestimate(x, g1, g2 = NULL, f = NULL, error = NULL, plot.action = 2,
  pointcol = 2, cex = 1, ...)
}
\arguments{
\item{x}{A single \code{linkdat} object or a list of \code{linkdat} and/or
\code{singleton} objects. (A third option is to provide a data frame, as
produced by \code{paramlink:::.ibdPrep}.)}

\item{g1, g2}{The pairs of individuals for which IBD estimates should be
 computed. Several formats are possible:  If \code{g1} is a vector of ID
 labels, and \code{g2} is NULL, then all pairs among the \code{g1} are included.
 If \code{g2} is not NULL, only combinations formed by \code{g1} and
 \code{g2} are considered.  Finally, \code{g1} can be given as a matrix with
 two columns and each row indicating a pair.

 If \code{x} is a list of \code{linkdat} objects, then all ID labels must
 be characters of the form 'X-Y', where X is the family ID, and Y the
 individual ID.}

\item{f}{A numeric vector containing the frequencies of the '2' allele. If
NULL (default), this is computed from \code{x}.}

\item{error}{A single numeric to be used in error modelling, or NULL. See
details.}

\item{plot.action}{An integer: 2 = make new triangle and draw points; 1 =
add points to existing triangle; 0 = no plotting.}

\item{pointcol}{A single numeric or character: Color specification for the
points in the plot.}

\item{cex}{A single numeric controlling point size (this is simply passed on 
to \code{\link{points}}.}

\item{\dots}{Other arguments.}
}
\value{
A matrix (or a list of matrices) with 6 columns: ID1, ID2, N
(#markers with no missing alleles), k0, k1, k2.
}
\description{
Estimate IBD coefficients (k0, k1, k2) for
specified pairs of pedigree members, using maximum likelihood methods.
The optimization machinery is imported from the \code{maxLik} package.
}
\details{
Our implementation is fairly close to the original description in (Thompson, 1975).
}
\examples{

x = cousinsPed(1)
x = simpleSim(x, 200, 1:2) # 200 equifrequent SNPs
est1 = IBDestimate(x, g1=3, g2=6)

# Estimation across families
x1 = branch(x, 3)
x2 = branch(x, 6)
x2$famid = 2

# With multiple pedigrees individuals are denoted 'famid-ID'
est2 = IBDestimate(list(x1,x2), g1='1-3', g2='2-6')

stopifnot(all.equal(est1[,4:6], est2[,4:6]))

}
\references{
E. A. Thompson (2000). \emph{Statistical Inferences from Genetic Data
 on Pedigrees.} NSF-CBMS Regional Conference Series in Probability and
 Statistics. Volume 6.
}
\seealso{
\code{\link{examineKinships}}, 
 \code{\link{IBDtriangle}}, \code{\link[maxLik]{maxLik}}
}
\author{
Magnus Dehli Vigeland
}
