% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{parcoordsProxy}
\alias{parcoordsProxy}
\title{Send commands to a Proxy instance in a Shiny app}
\usage{
parcoordsProxy(parcoordsId, session = shiny::getDefaultReactiveDomain(),
  deferUntilFlush = TRUE)
}
\arguments{
\item{parcoordsId}{single-element character vector indicating the output ID of the
parcoords to modify (if invoked from a Shiny module, the namespace will be added
automatically)}

\item{session}{the Shiny session object to which the map belongs; usually the
default value will suffice}

\item{deferUntilFlush}{indicates whether actions performed against this
instance should be carried out right away, or whether they should be held
until after the next time all of the outputs are updated; defaults to
\code{TRUE}}
}
\description{
Creates a parcoords-like object that can be used to customize and control a parcoords
that has already been rendered. For use in Shiny apps and Shiny docs only.
}
\details{
Normally, you create a parcoords chart using the \code{\link{parcoords}} function.
This creates an in-memory representation of a parcoords that you can customize.
Such a parcoords can be printed at the R console, included in an R Markdown
document, or rendered as a Shiny output.

In the case of Shiny, you may want to further customize a parcoords, even after it
is rendered to an output. At this point, the in-memory representation of the
parcoords is long gone, and the user's web browser has already realized the
parcoords instance.

This is where \code{parcoordsProxy} comes in. It returns an object that can
stand in for the usual parcoords object. The usual parcoords functions
can be called, and instead of customizing an in-memory representation,
these commands will execute on the live parcoords instance.
}
