% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finders.R
\name{path_to}
\alias{path_to}
\alias{get_item}
\alias{set_item}
\alias{get_container}
\alias{get_which}
\title{Find path to a particular kind of item}
\usage{
path_to(items, is_fn, ..., all = FALSE)

get_item(items, path)

set_item(items, path, value)

get_container(items, path)

get_which(path)
}
\arguments{
\item{items}{A list of latex items.}

\item{is_fn}{Which test function to use.}

\item{...}{Additional parameters to pass to \code{is_fn}.}

\item{all}{Find all matching, or the first?}

\item{path}{Integer vector of subitems}

\item{value}{A \link{LaTeX2item} to set as a value.}
}
\value{
\code{path_to()} returns the recursive path to the
first example matching the \code{is_fn} conditions,
or a list of paths to all matching items.

\code{get_item()} returns the item at the given path.

\code{set_item()} replaces the item at the given path, and returns the modified version of \code{items}.

\code{get_container()} returns the item
containing the given path

\code{get_which()} returns the index
of the item within its container.
}
\description{
Find path to a particular kind of item
}
\details{
\code{path_to()} does a recursive search in the order
items appear in the deparse.
}
\examples{
latex <- kableExtra::kbl(mtcars[1:2, 1:2], format = "latex", caption = "Sample table")
parsed <- parseLatex(latex)
parsed
path <- path_to(parsed, is_fn = is_env,
                        envtypes = "tabular")
get_item(parsed, path)
}
