% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_lab.R
\encoding{UTF-8}
\name{convert_lab}
\alias{convert_lab}
\title{Converts lab results to normal/abnormal based-on reference values.}
\usage{
convert_lab(
  d,
  code_results = "lab_result",
  code_reference = "lab_result_range",
  code_flag = "lab_result_abn"
)
}
\arguments{
\item{d}{data.table, database containing laboratory results data loaded using the \emph{load_lab} function.}

\item{code_results}{string vector, column name containing the results. Defaults to: \emph{"lab_result"}.}

\item{code_reference}{string vector, column name containing the reference ranges. Defaults to: \emph{"lab_result_range"}.}

\item{code_flag, }{string vector, column name containing the abnormal flags. Defaults to: \emph{"lab_result_abn"}.}
}
\value{
data.table, with three additional columns: \emph{"lab_result_pretty"} containing numerical results. In case of ">" or "<" notation,
the numeric value is returned, as we only have information that it is at least as much or not larger than a given value.
The other column: \emph{"lab_result_abn_pretty"} can take values: NORMAL/ABNORMAL, depending on whether the value is within the reference range.
Please be aware that there can be very different representations of values, and in some cases this will result in misclassification of values.
The third column: \emph{"lab_result_abn_flag_pretty"} gives abnormal if the original Abnormal_Flag column contains any information.
Borderline values are considered NORMAL.
}
\description{
Analyzes laboratory data loaded using \emph{load_lab}. Converts laboratory results to values without ">" or "<" by creating a column where these characters are removed.
Furthermore, adds two indicator columns where based-on the reference ranges or the Abnormal_Flag column in RPDR (lab_result_abn using load_lab), the value is considered normal or abnormal.
}
\examples{
\dontrun{
#Convert loaded lab results
data_lab_pretty <- convert_lab(d = data_lab)
data_lab_pretty[, c("lab_result", "lab_result_pretty", "lab_result_range",
"lab_result_abn_pretty", "lab_result_abn_flag_pretty")]
}
}
