\name{plot.rank_stability}
\alias{plot.rank_stability}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Plot outputs of PARSEC function \code{\link{rank_stability}.}
}
\description{
The function generates four plots, to reproduce the sequence of the average ranks and of the positions of the elements, in the rankings associated to the alpha-cut posets.

Rankings and average ranks have to be evaluted with the function \code{\link{rank_stability}}.

First and third plots show the sequence of average ranks, second and fourth show the sequence of rankings. Sequences in first and second plots are shown against the sequence of alpha-cuts, in third and fourth plots as a function of alpha values.
}
\usage{
\method{plot}{rank_stability}(x,
    which = 1:4, legend = TRUE, legend.x = "bottomleft",
    legend.y = NULL, legend.bg = "white", grid = TRUE,
    grid.lty = 2, grid.col = rgb(0, 0, 0, 1/7),
    grid.lwd = 1, y_axis = "reversed", ask = dev.interactive(),
    type = "l", col = gray(1:ncol(x$ranking)/ncol(x$ranking)/1.3),
    lwd = 3, lty = 1, ...
)}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
object of class \code{rank_stability} generated by function \code{\link{rank_stability}}.
}
  \item{which}{select a subset of the numbers 1:4, to specify the desired plots. See caption below (and the 'Details').
  }
  \item{legend}{
boolean argument to choose whether to show the legend in the plots.
}
  \item{legend.x, legend.y, legend.bg}{
arguments \code{x}, \code{y} and \code{bg} of the function \code{\link{legend}} defining the coordinates and the backgroud color of the legend.
}
  \item{grid}{
boolean argument to choose whether to show the grid in the plots.
}
  \item{grid.lty, grid.col, grid.lwd}{
arguments defining the line type, color and width of the grid.
}
  \item{y_axis}{if it is set equal to "reversed" plots show the y axis reversed.}
  \item{ask}{
boolean argument indicating whether the system has to ask users before changing plots.
}
  \item{type}{
1-character string giving the desired type of plot. See \code{\link{plot.default}} for details.
}
  \item{col}{
vector of colors. See \code{\link{matplot}} for details.
}
  \item{lwd}{
vector of line widths. See \code{\link{matplot}} for details.
}
  \item{lty}{
vector of line types. See \code{\link{matplot}} for details.
}
  \item{\dots}{
other arguments of function \code{\link{matplot}}.
}
}

\seealso{
\code{\link{rank_stability}}, \code{\link{legend}}, \code{\link{plot.default}}, \code{\link{matplot}}
}
\examples{
v1 <- as.ordered(c("a", "b", "c", "d"))
v2 <- 1:3
prof <- var2prof(varmod = list(v1 = as.ordered(c("a", "b", "c", "d")), v2 = 1:3))
np <- nrow(prof$profiles)

k <- 10 # number of populations
set.seed(0)
populations <- as.data.frame(lapply(1:k, function(x) round(runif(np)*100)))
rownames(populations) <- rownames(prof$profiles)
names(populations) <- paste0("P", 1:k)

x <- FFOD(profiles = prof, distributions = populations)

res <- rank_stability(x)
plot(res)
}