% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_call.R
\name{calls}
\alias{calls}
\alias{pd_is_call}
\alias{pd_is_symbol_call}
\alias{pd_get_call_symbol_id}
\alias{pd_get_call_arg_ids}
\title{Call nodes}
\usage{
pd_is_call(id, pd, calls = NULL, .check = TRUE)

pd_is_symbol_call(id, pd, .check = TRUE)

pd_get_call_symbol_id(id, pd, .check = TRUE)

pd_get_call_arg_ids(id, pd, .check = TRUE)
}
\arguments{
\item{id}{id of the expression of interest}

\item{pd}{The \code{\link{parse-data}} information}

\item{calls}{an optional list of calls to restrict consideration to.}

\item{.check}{Perform checks for input validation?}
}
\value{
a logical of the same length as \code{id}

a named list where each element is the id for the \code{expr} element of the argument.
}
\description{
Call nodes represent function calls.

Retrieves the ids of the arguments of a call as an integer vector.
}
\details{
The traditional call of
\code{function_name(arguments)} is a symbol call as \code{function_name}
is the symbol directly referencing the function to call.
Other calls may exists such as \code{function_array[[1]]()} which
first indexes the \code{function_array} then calls the returned function.
This qualifies as a call expression but not a symbol call expression.
We are often only concerned with symbol calls and not the anonymous
version.
}
\section{Functions}{
\itemize{
\item \code{pd_is_call}: Test if the node is a call expression.

\item \code{pd_is_symbol_call}: Test if the node is specifically a symbol call expression.

\item \code{pd_get_call_symbol_id}: Get the symbol, i.e. the name of the function, being called.

\item \code{pd_get_call_arg_ids}: test Get the set of arguments to the function call.
}}

\examples{
# load example file and get_parse data
ex.file <- system.file("examples", "example.R", package="parsetools")
exprs <- parse(ex.file, keep.source = TRUE)
pd <- get_parse_data(exprs)

# There are 3 expressions so there should be three roots.
sum(pd_is_root(pd$id, pd))
roots <- pd_all_root_ids(pd)

# which root is a call?
pd_is_call(roots, pd)
id <- roots[pd_is_call(roots, pd)]
# not all calls are symbole calls.
pd_is_symbol_call(id, pd)
# what is the symbol being called?
pd_text(pd_get_call_symbol_id(id, pd), pd)
# what are the arguments to the call
args <- pd_get_call_arg_ids(id, pd)
pd_token(pd_get_firstborn(args, pd), pd)
pd_text(pd_get_firstborn(args, pd), pd)
}
