% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_reg_h2o.R
\name{details_linear_reg_h2o}
\alias{details_linear_reg_h2o}
\title{Linear regression via h2o}
\description{
This model uses regularized least squares to fit models with numeric outcomes.
}
\details{
For this engine, there is a single mode: regression
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{mixture}: Proportion of Lasso Penalty (type: double, default: see
below)
\item \code{penalty}: Amount of Regularization (type: double, default: see
below)
}

By default, when not given a fixed \code{penalty},
\code{\link[h2o:h2o.glm]{h2o::h2o.glm()}} uses a heuristic approach to select
the optimal value of \code{penalty} based on training data. Setting the
engine parameter \code{lambda_search} to \code{TRUE} enables an efficient version
of the grid search, see more details at
\url{https://docs.h2o.ai/h2o/latest-stable/h2o-docs/data-science/algo-params/lambda_search.html}.

The choice of \code{mixture} depends on the engine parameter \code{solver}, which
is automatically chosen given training data and the specification of
other model parameters. When \code{solver} is set to \code{'L-BFGS'}, \code{mixture}
defaults to 0 (ridge regression) and 0.5 otherwise.
}

\subsection{Translation from parsnip to the original package}{

\code{\link[agua:h2o_train]{agua::h2o_train_glm()}} for \code{linear_reg()} is a
wrapper around \code{\link[h2o:h2o.glm]{h2o::h2o.glm()}} with
\code{family = "gaussian"}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{linear_reg(penalty = 1, mixture = 0.5) \%>\% 
  set_engine("h2o") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Linear Regression Model Specification (regression)
## 
## Main Arguments:
##   penalty = 1
##   mixture = 0.5
## 
## Computational engine: h2o 
## 
## Model fit template:
## agua::h2o_train_glm(x = missing_arg(), y = missing_arg(), lambda = 1, 
##     alpha = 0.5, family = "gaussian")
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.

By default, \code{\link[h2o:h2o.glm]{h2o::h2o.glm()}} uses the argument
\code{standardize = TRUE} to center and scale the data.
}

\subsection{Initializing h2o}{

To use the h2o engine with tidymodels, please run \code{h2o::h2o.init()}
first. By default, This connects R to the local h2o server. This needs
to be done in every new R session. You can also connect to a remote h2o
server with an IP address, for more details see
\code{\link[h2o:h2o.init]{h2o::h2o.init()}}.

You can control the number of threads in the thread pool used by h2o
with the \code{nthreads} argument. By default, it uses all CPUs on the host.
This is different from the usual parallel processing mechanism in
tidymodels for tuning, while tidymodels parallelizes over resamples, h2o
parallelizes over hyperparameter combinations for a given resample.

h2o will automatically shut down the local h2o instance started by R
when R is terminated. To manually stop the h2o server, run
\code{h2o::h2o.shutdown()}.
}
}
\keyword{internal}
