% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree.R
\name{boost_tree}
\alias{boost_tree}
\title{Boosted trees}
\usage{
boost_tree(
  mode = "unknown",
  engine = "xgboost",
  mtry = NULL,
  trees = NULL,
  min_n = NULL,
  tree_depth = NULL,
  learn_rate = NULL,
  loss_reduction = NULL,
  sample_size = NULL,
  stop_iter = NULL
)
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}

\item{mtry}{A number for the number (or proportion) of predictors that will
be randomly sampled at each split when creating the tree models
(specific engines only)}

\item{trees}{An integer for the number of trees contained in
the ensemble.}

\item{min_n}{An integer for the minimum number of data points
in a node that is required for the node to be split further.}

\item{tree_depth}{An integer for the maximum depth of the tree (i.e. number
of splits) (specific engines only).}

\item{learn_rate}{A number for the rate at which the boosting algorithm adapts
from iteration-to-iteration (specific engines only). This is sometimes referred to
as the shrinkage parameter.}

\item{loss_reduction}{A number for the reduction in the loss function required
to split further (specific engines only).}

\item{sample_size}{A number for the number (or proportion) of data that is
exposed to the fitting routine. For \code{xgboost}, the sampling is done at
each iteration while \code{C5.0} samples once during training.}

\item{stop_iter}{The number of iterations without improvement before
stopping (specific engines only).}
}
\description{
\code{boost_tree()} defines a model that creates a series of decision trees
forming an ensemble. Each tree depends on the results of previous trees.
All trees in the ensemble are combined to produce a final prediction. This
function can fit classification, regression, and censored regression models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("boost_tree")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.

Each of the arguments in this function other than \code{mode} and \code{engine} are
captured as \link[rlang:topic-quosure]{quosures}. To pass values
programmatically, use the \link[rlang:injection-operator]{injection operator} like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{value <- 1
boost_tree(argument = !!value)
}\if{html}{\out{</div>}}
}
\examples{
\dontshow{if (!parsnip:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
show_engines("boost_tree")

boost_tree(mode = "classification", trees = 20)
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("boost_tree")},
\code{\link[=xgb_train]{xgb_train()}}, \code{\link[=C5.0_train]{C5.0_train()}}
}
