% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_force.R
\docType{data}
\name{link_force}
\alias{link_force}
\title{Attract or repel linked particles}
\description{
This force works between linked particles and either attracts or repel them
from each other depending on the value of the strength and distance
parameters. The force is stronger the longer the linked particles are from
each other, mimicking the mechanics of a rubber band.
}
\section{Training parameters}{

The following parameters defines the training of the force and can be passed
along a call to \code{\link[=wield]{wield()}}
\itemize{
\item \code{strength} : The attractive force between the linked particles. The default
weighs edges from low-degree particles higher
(\code{strength = 1 / (min(degree(from), degree(to)))}). (\emph{tidy eval})
\item \code{distance} : The desired distance between linked particles. Defaults to
\code{30} (\emph{tidy eval})
\item \code{n_iter} : The number of iteration towards the optimal solution per
generation. Higher values leads to faster convergence (measured in number
of generations) at the expense of longer computation time per generation.
Defaults to \code{1}.
}
}

\seealso{
Other forces: 
\code{\link{center_force}},
\code{\link{collision_force}},
\code{\link{field_force}},
\code{\link{manybody_force}},
\code{\link{map_force}},
\code{\link{mean_force}},
\code{\link{random_force}},
\code{\link{reset_force}},
\code{\link{trap_force}},
\code{\link{x_force}},
\code{\link{y_force}}
}
\concept{forces}
\keyword{datasets}
