% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{assign_partition}
\alias{assign_partition}
\title{Process a dataset with a partitioner}
\usage{
assign_partition(.x, partitioner, .data, threshold, tolerance, var_prefix)
}
\arguments{
\item{.x}{the data or a \code{partition_step} object}

\item{partitioner}{a \code{partitioner}. See the \code{part_*()} functions and
\code{\link[=as_partitioner]{as_partitioner()}}.}

\item{.data}{a data.frame to partition}

\item{threshold}{the minimum proportion of information explained by a reduced
variable; \code{threshold} sets a boundary for information loss because each
reduced variable must explain at least as much as \code{threshold} as measured
by the metric.}

\item{tolerance}{a small tolerance within the threshold; if a reduction is
within the threshold plus/minus the tolerance, it will reduce.}
}
\value{
a \code{partition_step} object
}
\description{
\code{assign_partition()} is the primary handler for the partition algorithm and
is iterated by \code{reduce_partition_c()}. \code{assign_partition()} does initial set
up of the \code{partition_step} object and then applies the \code{partitioner} to each
iteration of the  \code{partition_step} via \code{direct_measure_reduce()}.
}
\keyword{internal}
