% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\name{computePairCoefficients}
\alias{computePairCoefficients}
\title{Compute the four coefficients \eqn{N_{11}}, \eqn{N_{10}},
 \eqn{N_{01}}, \eqn{N_{00}}}
\usage{
computePairCoefficients(p, q)
}
\arguments{
\item{p}{The partition \eqn{P}}

\item{q}{The partition \eqn{Q}}
}
\description{
Given two object partitions P and Q, of same length n,
each of them described as a vector of cluster ids,
compute the four coefficients (\eqn{N_{11}}, \eqn{N_{10}},
\eqn{N_{01}}, \eqn{N_{00}})
all of the pair comparison measures are based on.
}
\examples{
pc <- computePairCoefficients(new("Partition", c(0, 0, 0, 1, 1)), 
                              new("Partition", c(0, 0, 1, 1, 1)))
N11(pc) == 2
N10(pc) == 2
N01(pc) == 2
N00(pc) == 4

}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
