% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{czekanowski}
\alias{czekanowski}
\alias{czekanowski,Partition,Partition-method}
\alias{czekanowski,PairCoefficients,missing-method}
\title{Czekanowski Index}
\usage{
czekanowski(p, q)

\S4method{czekanowski}{Partition,Partition}(p, q)

\S4method{czekanowski}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the Czekanowski index
\deqn{\frac{2N_{11}}{2N_{11} + N_{10} + N_{01}}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
czekanowski(new("Partition", c(0, 0, 0, 1, 1)), 
            new("Partition", c(0, 0, 1, 1, 1))) == 0.5

}
\references{
\insertRef{Czekanowski1932}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
