% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_based.R
\docType{methods}
\name{larsenAone}
\alias{larsenAone}
\alias{larsenAone,Partition,Partition-method}
\title{Larsen & Aone Measure}
\usage{
larsenAone(p, q)

\S4method{larsenAone}{Partition,Partition}(p, q)
}
\arguments{
\item{p}{The partition \eqn{P}}

\item{q}{The partition \eqn{Q}}
}
\description{
Compute the measure of Larsen and Aone
\deqn{
\frac{1}{|\cal{P}|} 
\sum_{C \in \cal{P}}{\max_{D \in \cal{Q}}{\frac{2|C \cap D|}{|C| + |D|}}}
}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions
}}

\examples{
larsenAone(new("Partition", c(0, 0, 0, 1, 1)), 
           new("Partition", c(0, 0, 1, 1, 1))) == 0.8

}
\references{
\insertRef{Larsen1999}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
