% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{minkowskiMeasure}
\alias{minkowskiMeasure}
\alias{minkowskiMeasure,Partition,Partition-method}
\alias{minkowskiMeasure,PairCoefficients,missing-method}
\title{Minkowski Measure}
\usage{
minkowskiMeasure(p, q)

\S4method{minkowskiMeasure}{Partition,Partition}(p, q)

\S4method{minkowskiMeasure}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the Minkowski measure
\deqn{\sqrt{ \frac{N_{10} + N_{01}}{N_{11} + N_{10}} }}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
minkowskiMeasure(new("Partition", c(0, 0, 0, 1, 1)), 
                 new("Partition", c(0, 0, 1, 1, 1))) == 1

}
\references{
\insertRef{Minkowski1911}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
