% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_lat.R
\name{parse_lat}
\alias{parse_lat}
\title{Parse latitude values}
\usage{
parse_lat(lat, format = NULL)
}
\arguments{
\item{lat}{(numeric/integer/character) one or more latitude values}

\item{format}{(character) format, default often works}
}
\value{
numeric vector
}
\description{
Parse latitude values
}
\section{Errors}{

Throws warnings on parsing errors, and returns \code{NaN} in each case

Types of errors:
\itemize{
\item invalid argument: e.g., letters passed instead of numbers,
see \url{https://en.cppreference.com/w/cpp/error/invalid_argument}
\item out of range: numbers of out acceptable range, see
\url{https://en.cppreference.com/w/cpp/error/out_of_range}
\item out of latitude range: not within -90/90 range
}
}

\examples{
parse_lat("")
parse_lat("-91")
parse_lat("95")
parse_lat("asdfaf")

parse_lat("45")
parse_lat("-45")
parse_lat("-45.2323")

# out of range with std::stod?
parse_lat("-45.23232e24")
parse_lat("-45.23232e2")

# numeric input
parse_lat(1:10)
parse_lat(85:94)

# different formats
parse_lat("40.4183318 N")
parse_lat("40.4183318 S")
parse_lat("40 25 5.994") # => 40.41833

parse_lat("40.4183318N")
parse_lat("N40.4183318")
parse_lat("40.4183318S")
parse_lat("S40.4183318")

parse_lat("N 39 21.440") # => 39.35733
parse_lat("S 56 1.389") # => -56.02315

parse_lat("N40°25’5.994") # => 40.41833
parse_lat("40° 25´ 5.994\" N") # => 40.41833
parse_lat("40:25:6N")
parse_lat("40:25:5.994N")
parse_lat("40d 25’ 6\" N")
}
