% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathmap.R
\name{pathmap}
\alias{pathmap}
\title{Annotate Involved Genes In Pathways and Visualize Pathways}
\usage{
pathmap(pw_table, gene_data)
}
\arguments{
\item{pw_table}{Data frame of enrichment results. Columns are: "ID",
"Pathway", "occurrence", "lowest_p", "highest_p".}

\item{gene_data}{Single column data frame containing change values (e.g.
log(fold change) values) for significant genes.}
}
\value{
Data frame of enrichment results with genes involved in each pathway
  presented. Columns are: "ID", "Pathway", "occurrence", "lowest_p",
  "highest_p","Involved_genes". The function also creates visualizations of
  the pathways with the package \code{pathview} and saves them in the folder
  "pathway_maps" in the folder "pathfindr_Results" under the current working
  directory.
}
\description{
Annotate Involved Genes In Pathways and Visualize Pathways
}
\examples{
\dontrun{
pathmap(pathway_table, change_data)
}
}
\seealso{
\code{\link[pathview]{pathview}} for pathway-based data integration
  and visualization. See \code{\link{run_pathfindR}} for the wrapper function
  of the pathfindR workflow
}
