% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{fetch_gene_set}
\alias{fetch_gene_set}
\title{Fetch Gene Set Objects}
\usage{
fetch_gene_set(gene_sets = "KEGG", min_gset_size = 10,
  max_gset_size = 300, custom_genes = NULL,
  custom_descriptions = NULL)
}
\arguments{
\item{gene_sets}{Name of the gene sets to be used for enrichment analysis.
Available gene sets are "KEGG", "Reactome", "BioCarta", "GO-All",
"GO-BP", "GO-CC", "GO-MF", "mmu_KEGG" or "Custom".
If "Custom", the arguments \code{custom_genes} and \code{custom_descriptions}
must be specified. (Default = "KEGG")}

\item{min_gset_size}{minimum number of genes a term must contain (default = 10)}

\item{max_gset_size}{maximum number of genes a term must contain (default = 10)}

\item{custom_genes}{a list containing the genes involved in each custom
term. Each element is a vector of gene symbols located in the given custom
term. Names should correspond to the IDs of the custom terms.}

\item{custom_descriptions}{A vector containing the descriptions for each
custom  term. Names of the vector should correspond to the IDs of the custom
terms.}
}
\value{
a list containing 2 elements \describe{
  \item{genes_by_term}{list of vectors of genes contained in each term}
  \item{term_descriptions}{vector of descriptions per each term}
}
}
\description{
Function for obtaining the gene sets per term and the term descriptions to
be used for enrichment analysis.
}
\examples{
KEGG_gset <- fetch_gene_set()
GO_MF_gset <- fetch_gene_set("GO-MF")
}
