% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/paths.R
\name{is_windows_drive}
\alias{is_windows_drive}
\title{Is the path a Windows drive?}
\usage{
is_windows_drive(x)
}
\arguments{
\item{x}{A character vector of file paths. Defaults to files in the
current directory.}
}
\value{
A logical vector, \code{TRUE} when the path is a Windows drive name.
On non-Windows machines, the return value is \code{FALSE} everywhere.
}
\description{
Checks to see if the path is a Windows drive.
}
\note{
The check is done by regular expression: values are considered to be
Windows drive name if they consist of a letter followed by a colon,
optionally followed by a slash or backslash.
Paths are standardardized before checking, so \code{.} and \code{..} are
resolved to their actual locations rather than always returning \code{FALSE}.
}
\examples{
x <- c("c:", "c:/", "c:\\\\", "C:", "C:/", "C:\\\\", "c:/c", "cc:", NA)
# Warnings about OS suppressed so package checks pass on non-Windows systems.
suppressWarnings(is_windows_drive(x))
}
\seealso{
\code{\link{get_drive}}
}

