% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_dirs}
\alias{create_dirs}
\alias{create_files}
\alias{remove_dirs}
\title{Create or remove files and directories}
\usage{
create_dirs(x = temp_file(pattern = "dir"))

create_files(x = temp_file())

remove_dirs(x)
}
\arguments{
\item{x}{A character vector of paths of directories to create/remove. 
For \code{create_dirs}, it defaults to a directory inside \code{tempdir()}.}
}
\value{
A logical vector of successes of failures.
}
\description{
A vectorized version of \code{\link[base]{dir.create}}, and
\code{\link[base]{file.create}} and \code{\link[base]{unlink}} with more 
convenient defaults.
}
\note{
\code{create_dirs} will only attempt to create directories that don't 
already exist.
}
\examples{
\donttest{
dirs <- temp_dir(c("foo", "bar/baz"))
create_dirs(dirs)

# Check this worked:
assertive.files::assert_all_are_dirs(dirs)

files <- temp_dir("blah/blah/blah", LETTERS)
create_files(files)

assertive.files::assert_all_are_existing_files(files)

# Clean up
remove_dirs(temp_dir(c("foo", "bar", "blah")))
}
}
\seealso{
\code{\link[base]{dir.create}}, \code{\link[base]{unlink}}
}

