% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_dev_endpoint}
\alias{glue_create_dev_endpoint}
\title{Creates a new DevEndpoint}
\usage{
glue_create_dev_endpoint(EndpointName, RoleArn, SecurityGroupIds,
  SubnetId, PublicKey, PublicKeys, NumberOfNodes, ExtraPythonLibsS3Path,
  ExtraJarsS3Path, SecurityConfiguration, Tags, Arguments)
}
\arguments{
\item{EndpointName}{[required] The name to be assigned to the new DevEndpoint.}

\item{RoleArn}{[required] The IAM role for the DevEndpoint.}

\item{SecurityGroupIds}{Security group IDs for the security groups to be used by the new
DevEndpoint.}

\item{SubnetId}{The subnet ID for the new DevEndpoint to use.}

\item{PublicKey}{The public key to be used by this DevEndpoint for authentication. This
attribute is provided for backward compatibility, as the recommended
attribute to use is public keys.}

\item{PublicKeys}{A list of public keys to be used by the DevEndpoints for authentication.
The use of this attribute is preferred over a single public key because
the public keys allow you to have a different private key per client.

If you previously created an endpoint with a public key, you must remove
that key to be able to set a list of public keys: call the
\code{UpdateDevEndpoint} API with the public key content in the
\code{deletePublicKeys} attribute, and the list of new keys in the
\code{addPublicKeys} attribute.}

\item{NumberOfNodes}{The number of AWS Glue Data Processing Units (DPUs) to allocate to this
DevEndpoint.}

\item{ExtraPythonLibsS3Path}{Path(s) to one or more Python libraries in an S3 bucket that should be
loaded in your DevEndpoint. Multiple values must be complete paths
separated by a comma.

Please note that only pure Python libraries can currently be used on a
DevEndpoint. Libraries that rely on C extensions, such as the
\href{http://pandas.pydata.org/}{pandas} Python data analysis library, are
not yet supported.}

\item{ExtraJarsS3Path}{Path to one or more Java Jars in an S3 bucket that should be loaded in
your DevEndpoint.}

\item{SecurityConfiguration}{The name of the SecurityConfiguration structure to be used with this
DevEndpoint.}

\item{Tags}{The tags to use with this DevEndpoint. You may use tags to limit access
to the DevEndpoint. For more information about tags in AWS Glue, see
\href{http://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html}{AWS Tags in AWS Glue} in
the developer guide.}

\item{Arguments}{A map of arguments used to configure the DevEndpoint.}
}
\description{
Creates a new DevEndpoint.
}
\section{Request syntax}{
\preformatted{svc$create_dev_endpoint(
  EndpointName = "string",
  RoleArn = "string",
  SecurityGroupIds = list(
    "string"
  ),
  SubnetId = "string",
  PublicKey = "string",
  PublicKeys = list(
    "string"
  ),
  NumberOfNodes = 123,
  ExtraPythonLibsS3Path = "string",
  ExtraJarsS3Path = "string",
  SecurityConfiguration = "string",
  Tags = list(
    "string"
  ),
  Arguments = list(
    "string"
  )
)
}
}

\keyword{internal}
