% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_group}
\alias{quicksight_update_group}
\title{Changes a group description}
\usage{
quicksight_update_group(GroupName, Description, AwsAccountId, Namespace)
}
\arguments{
\item{GroupName}{[required] The name of the group that you want to update.}

\item{Description}{The description for the group that you want to update.}

\item{AwsAccountId}{[required] The ID for the AWS account that the group is in. Currently, you use the
ID for the AWS account that contains your Amazon QuickSight account.}

\item{Namespace}{[required] The namespace. Currently, you should set this to \code{default}.}
}
\description{
Changes a group description.
}
\details{
The permissions resource is
\code{arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> }.

The response is a group object.

\strong{CLI Sample:}

\code{aws quicksight update-group --aws-account-id=111122223333 --namespace=default --group-name=Sales --description="Sales BI Dashboards" }
}
\section{Request syntax}{
\preformatted{svc$update_group(
  GroupName = "string",
  Description = "string",
  AwsAccountId = "string",
  Namespace = "string"
)
}
}

\keyword{internal}
