% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearch_operations.R
\name{cloudsearch_describe_availability_options}
\alias{cloudsearch_describe_availability_options}
\title{Gets the availability options configured for a domain}
\usage{
cloudsearch_describe_availability_options(DomainName, Deployed)
}
\arguments{
\item{DomainName}{[required] The name of the domain you want to describe.}

\item{Deployed}{Whether to display the deployed configuration (\code{true}) or include any
pending changes (\code{false}). Defaults to \code{false}.}
}
\description{
Gets the availability options configured for a domain. By default, shows
the configuration with any pending changes. Set the \code{Deployed} option to
\code{true} to show the active configuration and exclude pending changes. For
more information, see \href{https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html}{Configuring Availability Options}
in the \emph{Amazon CloudSearch Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_availability_options(
  DomainName = "string",
  Deployed = TRUE|FALSE
)
}
}

\keyword{internal}
