% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_stop_stream_encryption}
\alias{kinesis_stop_stream_encryption}
\title{Disables server-side encryption for a specified stream}
\usage{
kinesis_stop_stream_encryption(StreamName, EncryptionType, KeyId)
}
\arguments{
\item{StreamName}{[required] The name of the stream on which to stop encrypting records.}

\item{EncryptionType}{[required] The encryption type. The only valid value is \code{KMS}.}

\item{KeyId}{[required] The GUID for the customer-managed AWS KMS key to use for encryption.
This value can be a globally unique identifier, a fully specified Amazon
Resource Name (ARN) to either an alias or a key, or an alias name
prefixed by "alias/".You can also use a master key owned by Kinesis Data
Streams by specifying the alias \code{aws/kinesis}.
\itemize{
\item Key ARN example:
\code{arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012}
\item Alias ARN example:
\code{arn:aws:kms:us-east-1:123456789012:alias/MyAliasName}
\item Globally unique key ID example:
\code{12345678-1234-1234-1234-123456789012}
\item Alias name example: \code{alias/MyAliasName}
\item Master key owned by Kinesis Data Streams: \code{alias/aws/kinesis}
}}
}
\description{
Disables server-side encryption for a specified stream.

Stopping encryption is an asynchronous operation. Upon receiving the
request, Kinesis Data Streams returns immediately and sets the status of
the stream to \code{UPDATING}. After the update is complete, Kinesis Data
Streams sets the status of the stream back to \code{ACTIVE}. Stopping
encryption normally takes a few seconds to complete, but it can take
minutes. You can continue to read and write data to your stream while
its status is \code{UPDATING}. Once the status of the stream is \code{ACTIVE},
records written to the stream are no longer encrypted by Kinesis Data
Streams.

API Limits: You can successfully disable server-side encryption 25 times
in a rolling 24-hour period.

Note: It can take up to 5 seconds after the stream is in an \code{ACTIVE}
status before all records written to the stream are no longer subject to
encryption. After you disabled encryption, you can verify that
encryption is not applied by inspecting the API response from
\code{PutRecord} or \code{PutRecords}.
}
\section{Request syntax}{
\preformatted{svc$stop_stream_encryption(
  StreamName = "string",
  EncryptionType = "NONE"|"KMS",
  KeyId = "string"
)
}
}

\keyword{internal}
