% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_describe_account_customization}
\alias{quicksight_describe_account_customization}
\title{Describes the customizations associated with the provided AWS account
and Amazon QuickSight namespace in an AWS Region}
\usage{
quicksight_describe_account_customization(AwsAccountId, Namespace,
  Resolved)
}
\arguments{
\item{AwsAccountId}{[required] The ID for the AWS account that you want to describe QuickSight
customizations for.}

\item{Namespace}{The QuickSight namespace that you want to describe QuickSight
customizations for.}

\item{Resolved}{The \code{Resolved} flag works with the other parameters to determine which
view of QuickSight customizations is returned. You can add this flag to
your command to use the same view that QuickSight uses to identify which
customizations to apply to the console. Omit this flag, or set it to
\code{no-resolved}, to reveal customizations that are configured at different
levels.}
}
\description{
Describes the customizations associated with the provided AWS account
and Amazon QuickSight namespace in an AWS Region. The QuickSight console
evaluates which customizations to apply by running this API operation
with the \code{Resolved} flag included.

To determine what customizations display when you run this command, it
can help to visualize the relationship of the entities involved.
\itemize{
\item \verb{AWS Account} - The AWS account exists at the top of the hierarchy.
It has the potential to use all of the AWS Regions and AWS Services.
When you subscribe to QuickSight, you choose one AWS Region to use
as your home Region. That's where your free SPICE capacity is
located. You can use QuickSight in any supported AWS Region.
\item \verb{AWS Region} - In each AWS Region where you sign in to QuickSight at
least once, QuickSight acts as a separate instance of the same
service. If you have a user directory, it resides in us-east-1,
which is the US East (N. Virginia). Generally speaking, these users
have access to QuickSight in any AWS Region, unless they are
constrained to a namespace.

To run the command in a different AWS Region, you change your Region
settings. If you're using the AWS CLI, you can use one of the
following options:
\itemize{
\item Use \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html}{command line options}.
\item Use \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html}{named profiles}.
\item Run \verb{aws configure} to change your default AWS Region. Use Enter
to key the same settings for your keys. For more information,
see \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html}{Configuring the AWS CLI}.
}
\item \code{Namespace} - A QuickSight namespace is a partition that contains
users and assets (data sources, datasets, dashboards, and so on). To
access assets that are in a specific namespace, users and groups
must also be part of the same namespace. People who share a
namespace are completely isolated from users and assets in other
namespaces, even if they are in the same AWS account and AWS Region.
\item \verb{Applied customizations} - Within an AWS Region, a set of QuickSight
customizations can apply to an AWS account or to a namespace.
Settings that you apply to a namespace override settings that you
apply to an AWS account. All settings are isolated to a single AWS
Region. To apply them in other AWS Regions, run the
\code{CreateAccountCustomization} command in each AWS Region where you
want to apply the same customizations.
}
}
\section{Request syntax}{
\preformatted{svc$describe_account_customization(
  AwsAccountId = "string",
  Namespace = "string",
  Resolved = TRUE|FALSE
)
}
}

\keyword{internal}
