% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_batch_get_named_query}
\alias{athena_batch_get_named_query}
\title{Returns the details of a single named query or a list of up to 50
queries, which you provide as an array of query ID strings}
\usage{
athena_batch_get_named_query(NamedQueryIds)
}
\arguments{
\item{NamedQueryIds}{[required] An array of query IDs.}
}
\value{
A list with the following syntax:\preformatted{list(
  NamedQueries = list(
    list(
      Name = "string",
      Description = "string",
      Database = "string",
      QueryString = "string",
      NamedQueryId = "string",
      WorkGroup = "string"
    )
  ),
  UnprocessedNamedQueryIds = list(
    list(
      NamedQueryId = "string",
      ErrorCode = "string",
      ErrorMessage = "string"
    )
  )
)
}
}
\description{
Returns the details of a single named query or a list of up to 50
queries, which you provide as an array of query ID strings. Requires you
to have access to the workgroup in which the queries were saved. Use
ListNamedQueriesInput to get the list of named query IDs in the
specified workgroup. If information could not be retrieved for a
submitted query ID, information about the query ID submitted is listed
under UnprocessedNamedQueryId. Named queries differ from executed
queries. Use BatchGetQueryExecutionInput to get details about each
unique query execution, and ListQueryExecutionsInput to get a list of
query execution IDs.
}
\section{Request syntax}{
\preformatted{svc$batch_get_named_query(
  NamedQueryIds = list(
    "string"
  )
)
}
}

\keyword{internal}
