% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticsearchservice_operations.R
\name{elasticsearchservice_reject_inbound_cross_cluster_search_connection}
\alias{elasticsearchservice_reject_inbound_cross_cluster_search_connection}
\title{Allows the destination domain owner to reject an inbound cross-cluster
search connection request}
\usage{
elasticsearchservice_reject_inbound_cross_cluster_search_connection(
  CrossClusterSearchConnectionId)
}
\arguments{
\item{CrossClusterSearchConnectionId}{[required] The id of the inbound connection that you want to reject.}
}
\value{
A list with the following syntax:\preformatted{list(
  CrossClusterSearchConnection = list(
    SourceDomainInfo = list(
      OwnerId = "string",
      DomainName = "string",
      Region = "string"
    ),
    DestinationDomainInfo = list(
      OwnerId = "string",
      DomainName = "string",
      Region = "string"
    ),
    CrossClusterSearchConnectionId = "string",
    ConnectionStatus = list(
      StatusCode = "PENDING_ACCEPTANCE"|"APPROVED"|"REJECTING"|"REJECTED"|"DELETING"|"DELETED",
      Message = "string"
    )
  )
)
}
}
\description{
Allows the destination domain owner to reject an inbound cross-cluster
search connection request.
}
\section{Request syntax}{
\preformatted{svc$reject_inbound_cross_cluster_search_connection(
  CrossClusterSearchConnectionId = "string"
)
}
}

\keyword{internal}
