% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_modify_instance_fleet}
\alias{emr_modify_instance_fleet}
\title{Modifies the target On-Demand and target Spot capacities for the
instance fleet with the specified InstanceFleetID within the cluster
specified using ClusterID}
\usage{
emr_modify_instance_fleet(ClusterId, InstanceFleet)
}
\arguments{
\item{ClusterId}{[required] The unique identifier of the cluster.}

\item{InstanceFleet}{[required] The unique identifier of the instance fleet.}
}
\value{
An empty list.
}
\description{
Modifies the target On-Demand and target Spot capacities for the
instance fleet with the specified InstanceFleetID within the cluster
specified using ClusterID. The call either succeeds or fails atomically.

The instance fleet configuration is available only in Amazon EMR
versions 4.8.0 and later, excluding 5.0.x versions.
}
\section{Request syntax}{
\preformatted{svc$modify_instance_fleet(
  ClusterId = "string",
  InstanceFleet = list(
    InstanceFleetId = "string",
    TargetOnDemandCapacity = 123,
    TargetSpotCapacity = 123
  )
)
}
}

\keyword{internal}
