% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_update_configuration}
\alias{kafka_update_configuration}
\title{Updates an MSK configuration}
\usage{
kafka_update_configuration(Arn, Description, ServerProperties)
}
\arguments{
\item{Arn}{[required] The Amazon Resource Name (ARN) of the configuration.}

\item{Description}{The description of the configuration revision.}

\item{ServerProperties}{[required] Contents of the server.properties file. When using the API, you must
ensure that the contents of the file are base64 encoded. When using the
AWS Management Console, the SDK, or the AWS CLI, the contents of
server.properties can be in plaintext.}
}
\value{
A list with the following syntax:\preformatted{list(
  Arn = "string",
  LatestRevision = list(
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    Description = "string",
    Revision = 123
  )
)
}
}
\description{
Updates an MSK configuration.
}
\section{Request syntax}{
\preformatted{svc$update_configuration(
  Arn = "string",
  Description = "string",
  ServerProperties = raw
)
}
}

\keyword{internal}
