% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_describe_data_source_permissions}
\alias{quicksight_describe_data_source_permissions}
\title{Describes the resource permissions for a data source}
\usage{
quicksight_describe_data_source_permissions(AwsAccountId, DataSourceId)
}
\arguments{
\item{AwsAccountId}{[required] The AWS account ID.}

\item{DataSourceId}{[required] The ID of the data source. This ID is unique per AWS Region for each AWS
account.}
}
\value{
A list with the following syntax:\preformatted{list(
  DataSourceArn = "string",
  DataSourceId = "string",
  Permissions = list(
    list(
      Principal = "string",
      Actions = list(
        "string"
      )
    )
  ),
  RequestId = "string",
  Status = 123
)
}
}
\description{
Describes the resource permissions for a data source.
}
\section{Request syntax}{
\preformatted{svc$describe_data_source_permissions(
  AwsAccountId = "string",
  DataSourceId = "string"
)
}
}

\keyword{internal}
