% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticsearchservice_operations.R
\name{elasticsearchservice_add_tags}
\alias{elasticsearchservice_add_tags}
\title{Attaches tags to an existing Elasticsearch domain}
\usage{
elasticsearchservice_add_tags(ARN, TagList)
}
\arguments{
\item{ARN}{[required] Specify the \code{ARN} for which you want to add the tags.}

\item{TagList}{[required] List of \code{Tag} that need to be added for the Elasticsearch domain.}
}
\value{
An empty list.
}
\description{
Attaches tags to an existing Elasticsearch domain. Tags are a set of
case-sensitive key value pairs. An Elasticsearch domain may have up to
10 tags. See \href{https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-managedomains-awsresorcetagging}{Tagging Amazon Elasticsearch Service Domains for more information.}
}
\section{Request syntax}{
\preformatted{svc$add_tags(
  ARN = "string",
  TagList = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
