% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_delete_worker_block}
\alias{mturk_delete_worker_block}
\title{The DeleteWorkerBlock operation allows you to reinstate a blocked Worker
to work on your HITs}
\usage{
mturk_delete_worker_block(WorkerId, Reason)
}
\arguments{
\item{WorkerId}{[required] The ID of the Worker to unblock.}

\item{Reason}{A message that explains the reason for unblocking the Worker. The Worker
does not see this message.}
}
\value{
An empty list.
}
\description{
The \code{\link[=mturk_delete_worker_block]{delete_worker_block}} operation allows
you to reinstate a blocked Worker to work on your HITs. This operation
reverses the effects of the CreateWorkerBlock operation. You need the
Worker ID to use this operation. If the Worker ID is missing or invalid,
this operation fails and returns the message “WorkerId is invalid.” If
the specified Worker is not blocked, this operation returns
successfully.
}
\section{Request syntax}{
\preformatted{svc$delete_worker_block(
  WorkerId = "string",
  Reason = "string"
)
}
}

\keyword{internal}
