% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearch_operations.R
\name{cloudsearch_update_scaling_parameters}
\alias{cloudsearch_update_scaling_parameters}
\title{Configures scaling parameters for a domain}
\usage{
cloudsearch_update_scaling_parameters(DomainName, ScalingParameters)
}
\arguments{
\item{DomainName}{[required]}

\item{ScalingParameters}{[required]}
}
\description{
Configures scaling parameters for a domain. A domain's scaling
parameters specify the desired search instance type and replication
count. Amazon CloudSearch will still automatically scale your domain
based on the volume of data and traffic, but not below the desired
instance type and replication count. If the Multi-AZ option is enabled,
these values control the resources used per Availability Zone. For more
information, see \href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html}{Configuring Scaling Options}
in the \emph{Amazon CloudSearch Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_scaling_parameters(
  DomainName = "string",
  ScalingParameters = list(
    DesiredInstanceType = "search.m1.small"|"search.m1.large"|"search.m2.xlarge"|"search.m2.2xlarge"|"search.m3.medium"|"search.m3.large"|"search.m3.xlarge"|"search.m3.2xlarge",
    DesiredReplicationCount = 123,
    DesiredPartitionCount = 123
  )
)
}
}

\keyword{internal}
