% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearchdomain_operations.R
\name{cloudsearchdomain_search}
\alias{cloudsearchdomain_search}
\title{Retrieves a list of documents that match the specified search criteria}
\usage{
cloudsearchdomain_search(cursor, expr, facet, filterQuery, highlight,
  partial, query, queryOptions, queryParser, return, size, sort, start,
  stats)
}
\arguments{
\item{cursor}{Retrieves a cursor value you can use to page through large result sets.
Use the \code{size} parameter to control the number of hits to include in
each response. You can specify either the \code{cursor} or \code{start} parameter
in a request; they are mutually exclusive. To get the first cursor, set
the cursor value to \code{initial}. In subsequent requests, specify the
cursor value returned in the hits section of the response.

For more information, see \href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/paginating-results.html}{Paginating Results}
in the \emph{Amazon CloudSearch Developer Guide}.}

\item{expr}{Defines one or more numeric expressions that can be used to sort results
or specify search or filter criteria. You can also specify expressions
as return fields.

You specify the expressions in JSON using the form
\code{\{"EXPRESSIONNAME":"EXPRESSION"\}}. You can define and use multiple
expressions in a search request. For example:

\code{\{"expression1":"_score*rating", "expression2":"(1/rank)*year"\}}

For information about the variables, operators, and functions you can
use in expressions, see \href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html#writing-expressions}{Writing Expressions}
in the \emph{Amazon CloudSearch Developer Guide}.}

\item{facet}{Specifies one or more fields for which to get facet information, and
options that control how the facet information is returned. Each
specified field must be facet-enabled in the domain configuration. The
fields and options are specified in JSON using the form
\code{\{\"FIELD\":\{\"OPTION\":VALUE,\"OPTION:\"STRING\"\},\"FIELD\":\{\"OPTION\":VALUE,\"OPTION\":\"STRING\"\}\}}.

You can specify the following faceting options:
\itemize{
\item \code{buckets} specifies an array of the facet values or ranges to count.
Ranges are specified using the same syntax that you use to search
for a range of values. For more information, see \href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/searching-ranges.html}{Searching for a Range of Values}
in the \emph{Amazon CloudSearch Developer Guide}. Buckets are returned in
the order they are specified in the request. The \code{sort} and \code{size}
options are not valid if you specify \code{buckets}.
\item \code{size} specifies the maximum number of facets to include in the
results. By default, Amazon CloudSearch returns counts for the
top 10. The \code{size} parameter is only valid when you specify the
\code{sort} option; it cannot be used in conjunction with \code{buckets}.
\item \code{sort} specifies how you want to sort the facets in the results:
\code{bucket} or \code{count}. Specify \code{bucket} to sort alphabetically or
numerically by facet value (in ascending order). Specify \code{count} to
sort by the facet counts computed for each facet value (in
descending order). To retrieve facet counts for particular values or
ranges of values, use the \code{buckets} option instead of \code{sort}.
}

If no facet options are specified, facet counts are computed for all
field values, the facets are sorted by facet count, and the top 10
facets are returned in the results.

To count particular buckets of values, use the \code{buckets} option. For
example, the following request uses the \code{buckets} option to calculate
and return facet counts by decade.

\code{\{"year":\{"buckets":\\["\\[1970,1979\\]","\\[1980,1989\\]","\\[1990,1999\\]","\\[2000,2009\\]","\\[2010,\}"\\]\}\}}

To sort facets by facet count, use the \code{count} option. For example, the
following request sets the \code{sort} option to \code{count} to sort the facet
values by facet count, with the facet values that have the most matching
documents listed first. Setting the \code{size} option to 3 returns only the
top three facet values.

\code{\{"year":\{"sort":"count","size":3\}\}}

To sort the facets by value, use the \code{bucket} option. For example, the
following request sets the \code{sort} option to \code{bucket} to sort the facet
values numerically by year, with earliest year listed first.

\code{\{"year":\{"sort":"bucket"\}\}}

For more information, see \href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/faceting.html}{Getting and Using Facet Information}
in the \emph{Amazon CloudSearch Developer Guide}.}

\item{filterQuery}{Specifies a structured query that filters the results of a search
without affecting how the results are scored and sorted. You use
\code{filterQuery} in conjunction with the \code{query} parameter to filter the
documents that match the constraints specified in the \code{query} parameter.
Specifying a filter controls only which matching documents are included
in the results, it has no effect on how they are scored and sorted. The
\code{filterQuery} parameter supports the full structured query syntax.

For more information about using filters, see \href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/filtering-results.html}{Filtering Matching Documents}
in the \emph{Amazon CloudSearch Developer Guide}.}

\item{highlight}{Retrieves highlights for matches in the specified \code{text} or \code{text-array}
fields. Each specified field must be highlight enabled in the domain
configuration. The fields and options are specified in JSON using the
form
\code{\{\"FIELD\":\{\"OPTION\":VALUE,\"OPTION:\"STRING\"\},\"FIELD\":\{\"OPTION\":VALUE,\"OPTION\":\"STRING\"\}\}}.

You can specify the following highlight options:
\itemize{
\item \code{format}: specifies the format of the data in the text field: \code{text}
or \code{html}. When data is returned as HTML, all non-alphanumeric
characters are encoded. The default is \code{html}.
\item \code{max_phrases}: specifies the maximum number of occurrences of the
search term(s) you want to highlight. By default, the first
occurrence is highlighted.
\item \code{pre_tag}: specifies the string to prepend to an occurrence of a
search term. The default for HTML highlights is
\code{&amp;lt;em&amp;gt;}. The default for text highlights is \code{*}.
\item \code{post_tag}: specifies the string to append to an occurrence of a
search term. The default for HTML highlights is
\code{&amp;lt;/em&amp;gt;}. The default for text highlights is \code{*}.
}

If no highlight options are specified for a field, the returned field
text is treated as HTML and the first match is highlighted with emphasis
tags: \code{&amp;lt;em&gt;search-term&amp;lt;/em&amp;gt;}.

For example, the following request retrieves highlights for the \code{actors}
and \code{title} fields.

\code{\{ "actors": \{\}, "title": \{"format": "text","max_phrases": 2,"pre_tag": "<b>","post_tag": "</b>"\} \}}}

\item{partial}{Enables partial results to be returned if one or more index partitions
are unavailable. When your search index is partitioned across multiple
search instances, by default Amazon CloudSearch only returns results if
every partition can be queried. This means that the failure of a single
search instance can result in 5xx (internal server) errors. When you
enable partial results, Amazon CloudSearch returns whatever results are
available and includes the percentage of documents searched in the
search results (percent-searched). This enables you to more gracefully
degrade your users' search experience. For example, rather than
displaying no results, you could display the partial results and a
message indicating that the results might be incomplete due to a
temporary system outage.}

\item{query}{[required] Specifies the search criteria for the request. How you specify the
search criteria depends on the query parser used for the request and the
parser options specified in the \code{queryOptions} parameter. By default,
the \code{simple} query parser is used to process requests. To use the
\code{structured}, \code{lucene}, or \code{dismax} query parser, you must also specify
the \code{queryParser} parameter.

For more information about specifying search criteria, see \href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/searching.html}{Searching Your Data}
in the \emph{Amazon CloudSearch Developer Guide}.}

\item{queryOptions}{Configures options for the query parser specified in the \code{queryParser}
parameter. You specify the options in JSON using the following form
\code{\{\"OPTION1\":\"VALUE1\",\"OPTION2\":VALUE2\"...\"OPTIONN\":\"VALUEN\"\}.}

The options you can configure vary according to which parser you use:
\itemize{
\item \code{defaultOperator}: The default operator used to combine individual
terms in the search string. For example: \code{defaultOperator: 'or'}.
For the \code{dismax} parser, you specify a percentage that represents
the percentage of terms in the search string (rounded down) that
must match, rather than a default operator. A value of \code{0\\\%} is the
equivalent to OR, and a value of \code{100\\\%} is equivalent to AND. The
percentage must be specified as a value in the range 0-100 followed
by the percent (\%) symbol. For example, \code{defaultOperator: 50\\\%}.
Valid values: \code{and}, \code{or}, a percentage in the range 0\%-100\%
(\code{dismax}). Default: \code{and} (\code{simple}, \code{structured}, \code{lucene}) or
\code{100} (\code{dismax}). Valid for: \code{simple}, \code{structured}, \code{lucene}, and
\code{dismax}.
\item \code{fields}: An array of the fields to search when no fields are
specified in a search. If no fields are specified in a search and
this option is not specified, all text and text-array fields are
searched. You can specify a weight for each field to control the
relative importance of each field when Amazon CloudSearch calculates
relevance scores. To specify a field weight, append a caret (\code{^})
symbol and the weight to the field name. For example, to boost the
importance of the \code{title} field over the \code{description} field you
could specify: \code{"fields":\\["title^5","description"\\]}. Valid
values: The name of any configured field and an optional numeric
value greater than zero. Default: All \code{text} and \code{text-array}
fields. Valid for: \code{simple}, \code{structured}, \code{lucene}, and \code{dismax}.
\item \code{operators}: An array of the operators or special characters you
want to disable for the simple query parser. If you disable the
\code{and}, \code{or}, or \code{not} operators, the corresponding operators (\code{+},
\code{|}, \code{-}) have no special meaning and are dropped from the search
string. Similarly, disabling \code{prefix} disables the wildcard operator
(\code{*}) and disabling \code{phrase} disables the ability to search for
phrases by enclosing phrases in double quotes. Disabling precedence
disables the ability to control order of precedence using
parentheses. Disabling \code{near} disables the ability to use the ~
operator to perform a sloppy phrase search. Disabling the \code{fuzzy}
operator disables the ability to use the ~ operator to perform a
fuzzy search. \code{escape} disables the ability to use a backslash (\code{\\})
to escape special characters within the search string. Disabling
whitespace is an advanced option that prevents the parser from
tokenizing on whitespace, which can be useful for Vietnamese. (It
prevents Vietnamese words from being split incorrectly.) For
example, you could disable all operators other than the phrase
operator to support just simple term and phrase queries:
\code{"operators":\\["and","not","or", "prefix"\\]}. Valid values: \code{and},
\code{escape}, \code{fuzzy}, \code{near}, \code{not}, \code{or}, \code{phrase}, \code{precedence},
\code{prefix}, \code{whitespace}. Default: All operators and special
characters are enabled. Valid for: \code{simple}.
\item \code{phraseFields}: An array of the \code{text} or \code{text-array} fields you
want to use for phrase searches. When the terms in the search string
appear in close proximity within a field, the field scores higher.
You can specify a weight for each field to boost that score. The
\code{phraseSlop} option controls how much the matches can deviate from
the search string and still be boosted. To specify a field weight,
append a caret (\code{^}) symbol and the weight to the field name. For
example, to boost phrase matches in the \code{title} field over the
\code{abstract} field, you could specify:
\code{"phraseFields":\\["title^3", "plot"\\]} Valid values: The name of
any \code{text} or \code{text-array} field and an optional numeric value
greater than zero. Default: No fields. If you don't specify any
fields with \code{phraseFields}, proximity scoring is disabled even if
\code{phraseSlop} is specified. Valid for: \code{dismax}.
\item \code{phraseSlop}: An integer value that specifies how much matches can
deviate from the search phrase and still be boosted according to the
weights specified in the \code{phraseFields} option; for example,
\code{phraseSlop: 2}. You must also specify \code{phraseFields} to enable
proximity scoring. Valid values: positive integers. Default: 0.
Valid for: \code{dismax}.
\item \code{explicitPhraseSlop}: An integer value that specifies how much a
match can deviate from the search phrase when the phrase is enclosed
in double quotes in the search string. (Phrases that exceed this
proximity distance are not considered a match.) For example, to
specify a slop of three for dismax phrase queries, you would specify
\code{"explicitPhraseSlop":3}. Valid values: positive integers.
Default: 0. Valid for: \code{dismax}.
\item \code{tieBreaker}: When a term in the search string is found in a
document's field, a score is calculated for that field based on how
common the word is in that field compared to other documents. If the
term occurs in multiple fields within a document, by default only
the highest scoring field contributes to the document's overall
score. You can specify a \code{tieBreaker} value to enable the matches in
lower-scoring fields to contribute to the document's score. That
way, if two documents have the same max field score for a particular
term, the score for the document that has matches in more fields
will be higher. The formula for calculating the score with a
tieBreaker is
\code{(max field score) + (tieBreaker) * (sum of the scores for the rest of the matching fields)}.
Set \code{tieBreaker} to 0 to disregard all but the highest scoring field
(pure max): \code{"tieBreaker":0}. Set to 1 to sum the scores from all
fields (pure sum): \code{"tieBreaker":1}. Valid values: 0.0 to 1.0.
Default: 0.0. Valid for: \code{dismax}.
}}

\item{queryParser}{Specifies which query parser to use to process the request. If
\code{queryParser} is not specified, Amazon CloudSearch uses the \code{simple}
query parser.

Amazon CloudSearch supports four query parsers:
\itemize{
\item \code{simple}: perform simple searches of \code{text} and \code{text-array} fields.
By default, the \code{simple} query parser searches all \code{text} and
\code{text-array} fields. You can specify which fields to search by with
the \code{queryOptions} parameter. If you prefix a search term with a
plus sign (+) documents must contain the term to be considered a
match. (This is the default, unless you configure the default
operator with the \code{queryOptions} parameter.) You can use the \code{-}
(NOT), \code{|} (OR), and \code{*} (wildcard) operators to exclude particular
terms, find results that match any of the specified terms, or search
for a prefix. To search for a phrase rather than individual terms,
enclose the phrase in double quotes. For more information, see
\href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/searching-text.html}{Searching for Text}
in the \emph{Amazon CloudSearch Developer Guide}.
\item \code{structured}: perform advanced searches by combining multiple
expressions to define the search criteria. You can also search
within particular fields, search for values and ranges of values,
and use advanced options such as term boosting, \code{matchall}, and
\code{near}. For more information, see \href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/searching-compound-queries.html}{Constructing Compound Queries}
in the \emph{Amazon CloudSearch Developer Guide}.
\item \code{lucene}: search using the Apache Lucene query parser syntax. For
more information, see \href{http://lucene.apache.org/core/4_6_0/queryparser/org/apache/lucene/queryparser/classic/package-summary.html#package_description}{Apache Lucene Query Parser Syntax}.
\item \code{dismax}: search using the simplified subset of the Apache Lucene
query parser syntax defined by the DisMax query parser. For more
information, see \href{http://wiki.apache.org/solr/DisMaxQParserPlugin#Query_Syntax}{DisMax Query Parser Syntax}.
}}

\item{return}{Specifies the field and expression values to include in the response.
Multiple fields or expressions are specified as a comma-separated list.
By default, a search response includes all return enabled fields
(\code{_all_fields}). To return only the document IDs for the matching
documents, specify \code{_no_fields}. To retrieve the relevance score
calculated for each document, specify \code{_score}.}

\item{size}{Specifies the maximum number of search hits to include in the response.}

\item{sort}{Specifies the fields or custom expressions to use to sort the search
results. Multiple fields or expressions are specified as a
comma-separated list. You must specify the sort direction (\code{asc} or
\code{desc}) for each field; for example, \code{year desc,title asc}. To use a
field to sort results, the field must be sort-enabled in the domain
configuration. Array type fields cannot be used for sorting. If no
\code{sort} parameter is specified, results are sorted by their default
relevance scores in descending order: \code{_score desc}. You can also sort
by document ID (\code{_id asc}) and version (\code{_version desc}).

For more information, see \href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/sorting-results.html}{Sorting Results}
in the \emph{Amazon CloudSearch Developer Guide}.}

\item{start}{Specifies the offset of the first search hit you want to return. Note
that the result set is zero-based; the first result is at index 0. You
can specify either the \code{start} or \code{cursor} parameter in a request, they
are mutually exclusive.

For more information, see \href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/paginating-results.html}{Paginating Results}
in the \emph{Amazon CloudSearch Developer Guide}.}

\item{stats}{Specifies one or more fields for which to get statistics information.
Each specified field must be facet-enabled in the domain configuration.
The fields are specified in JSON using the form:

\code{\{"FIELD-A":\{\},"FIELD-B":\{\}\}}

There are currently no options supported for statistics.}
}
\description{
Retrieves a list of documents that match the specified search criteria.
How you specify the search criteria depends on which query parser you
use. Amazon CloudSearch supports four query parsers:
}
\details{
\itemize{
\item \code{simple}: search all \code{text} and \code{text-array} fields for the
specified string. Search for phrases, individual terms, and
prefixes.
\item \code{structured}: search specific fields, construct compound queries
using Boolean operators, and use advanced features such as term
boosting and proximity searching.
\item \code{lucene}: specify search criteria using the Apache Lucene query
parser syntax.
\item \code{dismax}: specify search criteria using the simplified subset of the
Apache Lucene query parser syntax defined by the DisMax query
parser.
}

For more information, see \href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/searching.html}{Searching Your Data}
in the \emph{Amazon CloudSearch Developer Guide}.

The endpoint for submitting \code{Search} requests is domain-specific. You
submit search requests to a domain's search endpoint. To get the search
endpoint for your domain, use the Amazon CloudSearch configuration
service \code{DescribeDomains} action. A domain's endpoints are also
displayed on the domain dashboard in the Amazon CloudSearch console.
}
\section{Request syntax}{
\preformatted{svc$search(
  cursor = "string",
  expr = "string",
  facet = "string",
  filterQuery = "string",
  highlight = "string",
  partial = TRUE|FALSE,
  query = "string",
  queryOptions = "string",
  queryParser = "simple"|"structured"|"lucene"|"dismax",
  return = "string",
  size = 123,
  sort = "string",
  start = 123,
  stats = "string"
)
}
}

\keyword{internal}
