% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_add_application_input}
\alias{kinesisanalyticsv2_add_application_input}
\title{Adds a streaming source to your SQL-based Amazon Kinesis Data Analytics
application}
\usage{
kinesisanalyticsv2_add_application_input(ApplicationName,
  CurrentApplicationVersionId, Input)
}
\arguments{
\item{ApplicationName}{[required] The name of your existing application to which you want to add the
streaming source.}

\item{CurrentApplicationVersionId}{[required] The current version of your application. You can use the
DescribeApplication operation to find the current application version.}

\item{Input}{[required] The Input to add.}
}
\description{
Adds a streaming source to your SQL-based Amazon Kinesis Data Analytics
application.
}
\details{
You can add a streaming source when you create an application, or you
can use this operation to add a streaming source after you create an
application. For more information, see CreateApplication.

Any configuration update, including adding a streaming source using this
operation, results in a new version of the application. You can use the
DescribeApplication operation to find the current application version.
}
\section{Request syntax}{
\preformatted{svc$add_application_input(
  ApplicationName = "string",
  CurrentApplicationVersionId = 123,
  Input = list(
    NamePrefix = "string",
    InputProcessingConfiguration = list(
      InputLambdaProcessor = list(
        ResourceARN = "string"
      )
    ),
    KinesisStreamsInput = list(
      ResourceARN = "string"
    ),
    KinesisFirehoseInput = list(
      ResourceARN = "string"
    ),
    InputParallelism = list(
      Count = 123
    ),
    InputSchema = list(
      RecordFormat = list(
        RecordFormatType = "JSON"|"CSV",
        MappingParameters = list(
          JSONMappingParameters = list(
            RecordRowPath = "string"
          ),
          CSVMappingParameters = list(
            RecordRowDelimiter = "string",
            RecordColumnDelimiter = "string"
          )
        )
      ),
      RecordEncoding = "string",
      RecordColumns = list(
        list(
          Name = "string",
          Mapping = "string",
          SqlType = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
